//       _______  _    _  _   _  ______   _____
//      |__   __|| |  | || \ | ||  ____| / ____|
//         | |   | |  | ||  \| || |__   | (___
//         | |   | |  | || . ` ||  __|   \___ \
//         | |   | |__| || |\  || |____  ____) |
//         |_|    \____/ |_| \_||______||_____/
//
//  defines background music tunes
//  each each entry consists of note duration and note number
//  valid note numbers are 0..95 0 is A(octave 0 27.5Hz) 95 is F#(octave7 6644.875Hz)
//  Note number N = (12/ln(2))*ln(f/27.5)
//  frequency   f = 27.5*2^(N/12)
//  Therefore middle C is N=51
#ifndef __TUNES_H__

#define END_MARKER     0x00
#define STOP_MARKER    0x00
#define REPEAT_MARKER  0x01

__rom NoteType MagneticR[]={  {2 ,56}, // 1/8 F
                              {4 ,55}, // 1/4 E
                              {10,54}, // 5/4 Eb
                              {2 ,56},
                              {4 ,54},
                              {10,53}, //
                              {2 ,56},
                              {2 ,57},
                              {2 ,58},
                              {4 ,59},
                              {2, 60},
                              {2, 61},
                              {2, 62}, //
                              {4, 63},
                              {4, 0xFF},
                              {4, 68},
                              {4, 0xFF}, //
                              {2, 53},
                              {2, 62},
                              {2, 58},
                              {2, 56},
                              {2, 54},
                              {4, 63},
                              {2, 64}, //  Line2
                              {2, 65},
                              {2, 56},
                              {2, 61},
                              {2, 53},
                              {2, 58},
                              {5, 56},
                              {1, 0xFF},//
                              {1, 56},
                              {1, 0xFF},
                              {3, 56},
                              {1, 0xFF},
                              {4, 56},
                              {2, 58},
                              {3, 56},
                              {1, 0xFF}, //
                              {1, 56},
                              {1, 0xFF},
                              {3, 56},
                              {1, 0xFF},
                              {4, 56},
                              {2, 58},
                              {4, 56}, //
                              {2, 53},
                              {2, 62},
                              {2, 58},
                              {2, 56},
                              {2, 54},
                              {4, 63},
                              {2, 64}, //
                              {2, 65},
                              {2, 56},
                              {2, 61},
                              {2, 65},
                              {2, 70},
                              {6, 73}, // Line 3
                              {2, 72},
                              {2, 75},
                              {2, 77},
                              {4, 78},
                              {2, 77},
                              {4, 72}, //
                              {2, 75},
                              {2, 73},
                              {2, 72},
                              {7, 73},
                              {1, 0xFF},
                              {4, 73},  //
                              {2, 61},
                              {2, 70},
                              {2, 58},
                              {2, 61},
                              {3, 68},
                              {1, 0xFF},
                              {2, 56}, //
                              {2, 66},
                              {2, 58},
                              {2, 66},
                              {4, 65},
                              {2, 56},
                              {4, 68}, //
                              {2, 73},
                              {2, 61},
                              {2, 70},
                              {2, 58},
                              {2, 61},
                              {3, 68},
                              {1, 0xFF},
                              {2, 56}, //  Line 4
                              {2, 66},
                              {2, 58},
                              {2, 66},
                              {8, 65},
                              {4, 73}, //
                              {2, 61},
                              {2, 70},
                              {2, 58},
                              {2, 61},
                              {3, 68},
                              {1, 0xFF},
                              {2, 56}, //
                              {2, 66},
                              {2, 58},
                              {2, 66},
                              {4, 65},
                              {2, 56},
                              {4, 68}, //
                              {2, 73},
                              {2, 61},
                              {2, 70},
                              {2, 58},
                              {2, 61},
                              {3, 68},
                              {1, 0xFF},
                              {2, 56}, //
                              {2, 66},
                              {2, 58},
                              {2, 66},
                              {4, 65},
                              {2, 58},
                              {2, 56},
                              {2, 54},//
                              {END_MARKER,REPEAT_MARKER}          // end marker
                             };  // melody for right speaker

__rom NoteType MagneticL[]={  {2 ,44}, // 1/8 F
                              {4 ,43}, // 1/4 E
                              {10,42}, // 5/4 Eb
                              {2 ,44},
                              {4 ,42},
                              {10,41}, //
                              {2 ,44},
                              {2 ,45},
                              {2 ,46},
                              {4 ,47},
                              {2, 48},
                              {2, 49},
                              {2, 50}, //
                              {4, 51},
                              {4, 0xFF},
                              {4, 44},
                              {4, 0xFF},
                              {4, 37},
                              {4, 49},
                              {4, 39},
                              {4, 48}, //  Line2
                              {4, 37},
                              {4, 49},
                              {4, 37},
                              {4, 49}, //
                              {4, 36},
                              {4, 48},
                              {4, 32},
                              {4, 48}, //
                              {4, 37},
                              {4, 49},
                              {4, 37},
                              {4, 49}, //
                              {4, 37},
                              {4, 49},
                              {4, 39},
                              {4, 48}, //
                              {4, 37},
                              {4, 44},
                              {4, 37},
                              {4, 34}, // Line 3
                              {4, 33},
                              {4, 45},
                              {4, 29},
                              {4, 45}, //
                              {4, 34},
                              {4, 46},
                              {4, 29},
                              {3, 46},
                              {1, 0xFF}, //
                              {4, 46},
                              {4, 42},
                              {4, 41},
                              {4, 53},   //
                              {4, 32},
                              {4, 54},
                              {4, 49},
                              {4, 47},   //
                              {4, 46},
                              {4, 42},
                              {4, 41},
                              {4, 53}, // Line 4
                              {4, 32},
                              {4, 54},
                              {4, 49},
                              {4, 44}, //
                              {4, 46},
                              {4, 42},
                              {4, 41},
                              {4, 53}, //
                              {4, 32},
                              {4, 54},
                              {4, 49},
                              {4, 47},   //
                              {4, 46},
                              {4, 42},
                              {4, 41},
                              {4, 53}, //
                              {4, 32},
                              {4, 54},
                              {4, 49},
                              {4, 48},
                              {END_MARKER,REPEAT_MARKER}          // end marker
                             };  // melody for right speaker


__rom NoteType OkSoundR[]=    {{1 ,58}, // 1/8 G
                              {1 ,60},
                              {1 ,58},
                              {1 ,55}, //
                              {1 ,56},
                              {1 ,58},
                              {1 ,56},
                              {1 ,53}, //
                              {1 ,51},
                              {1 ,0xFF},
                              {1 ,58},
                              {1 ,0xFF}, //
                              {1 ,63},
                              {3 ,0xFF},
                              {END_MARKER,STOP_MARKER}          // end marker
                             };  // melody for right speaker

__rom NoteType OkSoundL[]=    {{1 ,43}, // 1/8 G
                              {1 ,0xFF},
                              {1 ,46},
                              {1 ,0xFF}, //
                              {1 ,41},
                              {1 ,0xFF},
                              {1 ,38},
                              {1 ,0xFF}, //
                              {1 ,39},
                              {1 ,0xFF},
                              {1 ,34},
                              {1 ,0xFF}, //
                              {1 ,27},
                              {3 ,0xFF},
                              {END_MARKER,STOP_MARKER}          // end marker
                             };  // melody for right speaker

__rom NoteType GriegR[]=     {{1 ,53}, //
                              {1 ,0xFF},
                              {1 ,55},
                              {1 ,0xFF},
                              {1 ,56},
                              {1 ,0xFF},
                              {1 ,58},
                              {1 ,0xFF},
                              {1 ,60},
                              {1 ,0xFF},
                              {1 ,56},
                              {1 ,0xFF},
                              {3 ,60},
                              {1 ,0xFF}, //
                              {1 ,59},
                              {1 ,0xFF},
                              {1 ,55},
                              {1 ,0xFF},
                              {3 ,59},
                              {1 ,0xFF},
                              {1 ,58},
                              {1 ,0xFF},
                              {1 ,54},
                              {1 ,0xFF},
                              {3 ,58},
                              {1 ,0xFF}, //
                              {1 ,53},
                              {1 ,0xFF},
                              {1 ,55},
                              {1 ,0xFF},
                              {1 ,56},
                              {1 ,0xFF},
                              {1 ,58},
                              {1 ,0xFF},
                              {1 ,60},
                              {1 ,0xFF},
                              {1 ,56},
                              {1 ,0xFF},
                              {1 ,60},
                              {1 ,0xFF},
                              {1 ,65},
                              {1 ,0xFF},//
                              {1 ,63},
                              {1 ,0xFF},
                              {1 ,60},
                              {1 ,0xFF},
                              {1 ,56},
                              {1 ,0xFF},
                              {1 ,60},
                              {1 ,0xFF},
                              {7 ,63},
                              {1 ,0xFF},
                              {END_MARKER,REPEAT_MARKER}          // end marker
                             };  // melody for right speaker

__rom NoteType GriegL[]=     {{3 ,41}, //
                              {1 ,0xFF},
                              {3 ,36},
                              {1 ,0xFF},
                              {3 ,41},
                              {1 ,0xFF},
                              {3 ,36},
                              {1, 0xFF},//
                              {3 ,41},
                              {1 ,0xFF},
                              {3 ,36},
                              {1 ,0xFF},
                              {3 ,41},
                              {1 ,0xFF},
                              {3 ,36},
                              {1 ,0xFF},//
                              {3 ,41},
                              {1 ,0xFF},
                              {3 ,36},
                              {1 ,0xFF},
                              {3 ,41},
                              {1 ,0xFF},
                              {3 ,36},
                              {1 ,0xFF},
                              {3 ,44},
                              {5 ,0xFF},
                              {7 ,44},
                              {1 ,0xFF},

                              {END_MARKER,REPEAT_MARKER}          // end marker
                             };  // melody for right speaker


__rom NoteType ErrorL[]= {{2,60},
                          {3,0xFF},
                          {2,59},
                          {3,0xFF},
                          {END_MARKER,REPEAT_MARKER}          // end marker
                         };  // melody for right speaker
__rom NoteType ErrorR[]= {{2,59},
                          {3,0xFF},
                          {2,58},
                          {3,0xFF},
                          {END_MARKER,REPEAT_MARKER}          // end marker
                         };  // melody for right speaker


#define __TUNES_H__
#endif
